/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.text.hyperlink;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.util.EditorUtil;
import java.io.File;
import java.net.URI;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class EditorTargetRegionHyperlink
implements IHyperlink {
    private final IRegion hyperlinkRegion;
    private final URI targetFilePath;
    private final IRegion targetRegion;
    private String typeLabel;

    public EditorTargetRegionHyperlink(IRegion hyperlinkRegion, URI targetFilePath, String typeLabel, IRegion targetRegion) {
        this.hyperlinkRegion = hyperlinkRegion;
        this.targetFilePath = targetFilePath;
        this.typeLabel = typeLabel;
        this.targetRegion = targetRegion;
    }

    public IRegion getHyperlinkRegion() {
        return this.hyperlinkRegion;
    }

    public IRegion getTargetRegion() {
        return this.targetRegion;
    }

    public URI getTargetURI() {
        return this.targetFilePath;
    }

    public String getTypeLabel() {
        return this.typeLabel;
    }

    public String getHyperlinkText() {
        return null;
    }

    public void open() {
        if (this.targetFilePath == null || this.targetRegion == null) {
            return;
        }
        try {
            File file = new File(this.targetFilePath);
            IEditorPart editor = EditorUtil.openInEditor(file);
            if (editor instanceof AbstractTextEditor) {
                ((AbstractTextEditor)editor).selectAndReveal(this.targetRegion.getOffset(), this.targetRegion.getLength());
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
        }
    }
}

